module apply

// This application reads in two dynamic, applies them (lazily) to each other
// and saves (lazy) result.

import StdDynamic, StdEnv

:: Tree a = Node a (Tree a) (Tree a) | Leaf | Test [Tree a] Real

Start world
	// read function
	# (ok,f,world)
		= readDynamic (p +++ "function") world
	| not ok
		= abort " could not read"
		

	// value function
	# (ok,v,world)
		= readDynamic (p +++ "value") world
	| not ok
		= abort " could not read"

	# applied_dynamic
		= apply f v;
		
	// write dynamic; note that the dynamic contains lazy references to the dynamics
	// 'function' and 'value'.
	#! (ok2,world)
		= writeDynamic (p +++ "bool") DynamicDefaultOptions applied_dynamic world

	| not ok2
		= abort "could not write dynamic"

	= (world);
where
//	apply (f :: a -> b) (v :: a) -- laziness not (yet) fully supported
	apply (f :: (Tree Int) -> Real) (v :: (Tree Int))
		= dynamic f v 
	apply _ _
		= abort "unmatched"
		
	p
		= "C:\\WINDOWS\\Desktop\\Distribution\\Examples\\Dynamic 0.0\\DynamicApply\\"